#ifndef __ASM_MACH_LOONGSON_BOOT_PARAM_H_
#define __ASM_MACH_LOONGSON_BOOT_PARAM_H_

#define SYSTEM_RAM_LOW		1
#define SYSTEM_RAM_HIGH		2
#define MEM_RESERVED		3
#define PCI_IO			4
#define PCI_MEM			5
#define LOONGSON_CFG_REG	6
#define VIDEO_ROM		7
#define ADAPTER_ROM		8 
#define ACPI_TABLE		9
#define SMBIOS_TABLE		10
#define MAX_MEMORY_TYPE		11

struct efi_systab {
	unsigned long long fw_vendor;	/* physical addr of CHAR16 vendor string */
	unsigned long long fw_revision;	/* vesion of efi */
	unsigned long long con_in_handle;	/* control handle of input */
	unsigned long long con_in;	/* control input,support for inputing in kernel */
	unsigned long long con_out_handle;	/* control handle of output */
	unsigned long long con_out;	/* control output,support for outputing in kernel */
	unsigned long long stderr_handle;	/* standed error handle */
	unsigned long long boottime;	/* boottime */
	unsigned int nr_tables;		/* table id */
	unsigned long long tables;	/* all tables entry */
};

#define LOONGSON3_BOOT_MEM_MAP_MAX 128
struct efi_memory_map_loongson{
	u16 vers;	/*version of efi_memory_map*/
	u32 nr_map;	/*number of memory_maps*/
	u32 mem_freq;	/*memory frequence*/
	struct mem_map{
		u32 node_id;	/*node_id which memory attached to*/
		u32 mem_type;	/*id of the node memory attached to*/
		u64 mem_start;	/*memory map start address*/
		u32 mem_size;	/*for each memory_map size,not the total size*/
	}map[LOONGSON3_BOOT_MEM_MAP_MAX];
}__attribute__((packed));

enum loongson_cpu_type
{
	Loongson_2F,
	Loongson_2E,
	Loongson_3A,
	Loongson_3B,
	Loongson_1A,
	Loongson_1B
};

/*
 * Capability and feature descriptor structure for MIPS CPU
 */
struct efi_cpuinfo_loongson {
	u16 vers; /*version of efi_cpuinfo_loongson*/
	u32 processor_id;//6505, 6506-3b prid
	enum loongson_cpu_type  cputype;//3a-3b
	u32 total_node;   /* physical core number */
	u32 cpu_startup_core_id; /* Core id: */
	u32 cpu_clock_freq; //cpu_clock 
	u32 nr_cpus; 
}__attribute__((packed));

struct system_loongson{
	u16 vers;/*version of system_loongson*/
	u32 ccnuma_smp; // 0:no numa; 1: has numa
	u32 sing_double_channel;//1:single; 2:double
}__attribute__((packed));

struct irq_source_routing_table {
	u16 vers;
	u16 size;
	u16 rtr_bus;
	u16 rtr_devfn; 
	u32 vendor;
	u32 device;
	u32 PIC_type;   // conform use HT or PCI to route to CPU-PIC
	u64 ht_int_bit; // 3a: 1<<24; 3b:1<<16
	u64 ht_enable;  // irqs used in this PIC.eg:3a-0x0000d17a
	u32 node_id;    // node id, 0x0 —0, 0x1—1; 0x10—2；0x11—3；0x100—4
	u64 pci_mem_start_addr;
	u64 pci_mem_end_addr;
	u64 pci_io_start_addr;
	u64 pci_io_end_addr;
	u64 pci_config_addr;
}__attribute__((packed));

struct interface_info{
	u16 vers; /*version of the specificition*/
	u16 size;
	u8  flag;
	char description[64];
}__attribute__((packed));

#define MAX_RESOURCE_NUMBER 128
struct resource_loongson {
	u64 start; /*resource start address*/
	u64 end; /*resource end address*/
	char name[64];
	u32 flags;
};
  
struct archdev_data {};  /*arch specific additions*/

struct board_devices{
	char name[64]; /*hold the device name*/
	u32 num_resources; /*number of device_resource*/
	struct resource_loongson resource[MAX_RESOURCE_NUMBER]; /*for each device`s resource*/
	/*arch specific additions*/
	struct archdev_data archdata; 
};

struct loongson_special_attribute{
	u16 vers; /*version of this special*/
	char special_name[64]; /*special_atribute_name*/
	u32 loongson_special_type; /*type of special device*/
	struct resource_loongson resource[MAX_RESOURCE_NUMBER]; /*for each device`s resource*/
};

struct loongson_params{
	u64 memory_offset;	/* efi_memory_map_loongson struct offset*/ 
	u64 cpu_offset;		/* efi_cpuinfo_loongson struct offset*/
	u64 system_offset;  	/* system_loongson struct offset*/
	u64 irq_offset;  	/* irq_source_routing_table struct offset*/
	u64 interface_offset;  	/* interface_info struct offset*/
	u64 special_offset;  	/* loongson_special_attribute struct offset*/
	u64 boarddev_table_offset;  /* board_devices offset*/
};

struct smbios_tables {
	u16 vers; /*version of smbios*/
	u64 vga_bios;/*vga_bios address*/
	struct loongson_params lp;
};

struct efi_reset_system_t{
	u64 ResetCold;
	u64 ResetWarm;
	u64 ResetType;
	u64 Shutdown;
};

struct efi_loongson {
	u64 mps;	/* MPS table */
	u64 acpi;	/* ACPI table (IA64 ext 0.71) */
	u64 acpi20;	/* ACPI table (ACPI 2.0) */
	struct smbios_tables smbios;	/* SM BIOS table */
	u64 sal_systab;	/* SAL system table */
	u64 boot_info;	/* boot info table */
};

struct boot_params{
	struct efi_loongson efi;
	struct efi_reset_system_t reset_system;
};

extern u64 pci_mem_start_addr,pci_mem_end_addr;
extern u64 ht_control_base;
extern u64 loongson_pciio_base;
extern u32 nr_cpu_loongson;
extern enum loongson_cpu_type cputype;
extern struct efi_memory_map_loongson *emap;
#endif
