/*
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */
#include <linux/fs.h>
#include <linux/fcntl.h>
#include <linux/mm.h>
#include <asm/bootinfo.h>
#include <loongson.h>
#include <mem.h>
#include <pci.h>
#include <boot_param.h>

extern unsigned int has_smbios;
extern unsigned long smbios_addr;

void __init prom_init_memory(void)
{
	int i;
	u32 node_id;
	u32 mem_type;

	/* parse memory information */
	for (i = 0; i < emap->nr_map; i++){
		node_id = emap->map[i].node_id;
		mem_type = emap->map[i].mem_type;

		if (node_id == 0) {
			switch (mem_type) {
			case SYSTEM_RAM_LOW:
			case SYSTEM_RAM_HIGH:
				add_memory_region(emap->map[i].mem_start,
					(u64)emap->map[i].mem_size << 20,
					BOOT_MEM_RAM);
				break;
			case MEM_RESERVED:
				add_memory_region(emap->map[i].mem_start,
					(u64)emap->map[i].mem_size << 20,
					BOOT_MEM_RESERVED);
				break;
			case SMBIOS_TABLE:
				has_smbios = 1;
				smbios_addr = emap->map[i].mem_start &
					0x000000000ffffffful;
				break;
			}
		}
	}
}

/* override of arch/mips/mm/cache.c: __uncached_access */
int __uncached_access(struct file *file, unsigned long addr)
{
	if (file->f_flags & O_DSYNC)
		return 1;

	return addr >= __pa(high_memory) ||
		((addr >= LOONGSON_MMIO_MEM_START) &&
		 (addr < LOONGSON_MMIO_MEM_END)); //cww??
}

#ifdef CONFIG_CPU_SUPPORTS_UNCACHED_ACCELERATED

#include <linux/pci.h>
#include <linux/sched.h>
#include <asm/current.h>

static unsigned long uca_start, uca_end;

pgprot_t phys_mem_access_prot(struct file *file, unsigned long pfn,
			      unsigned long size, pgprot_t vma_prot)
{
	unsigned long offset = pfn << PAGE_SHIFT;
	unsigned long end = offset + size;

	if (__uncached_access(file, offset)) {
		if (uca_start && (offset >= uca_start) &&
		    (end <= uca_end))
			return __pgprot((pgprot_val(vma_prot) &
					 ~_CACHE_MASK) |
					_CACHE_UNCACHED_ACCELERATED);
		else
			return pgprot_noncached(vma_prot);
	}
	return vma_prot;
}

static int __init find_vga_mem_init(void)
{
	struct pci_dev *dev = 0;
	struct resource *r;
	int idx;

	if (uca_start)
		return 0;

	for_each_pci_dev(dev) {
		if ((dev->class >> 16) == PCI_BASE_CLASS_DISPLAY) {
			for (idx = 0; idx < PCI_NUM_RESOURCES; idx++) {
				r = &dev->resource[idx];
				if (!r->start && r->end)
					continue;
				if (r->flags & IORESOURCE_IO)
					continue;
				if (r->flags & IORESOURCE_MEM) {
					uca_start = r->start;
					uca_end = r->end;
					return 0;
				}
			}
		}
	}

	return 0;
}

late_initcall(find_vga_mem_init);
#endif /* !CONFIG_CPU_SUPPORTS_UNCACHED_ACCELERATED */
